// Copyright (c) 2016-2019 Snowflake Computing
//
// Header files that will be exposed to the user
// Only add definition necessary here

#ifndef PROJECT_SF_ODBC_H
#define PROJECT_SF_ODBC_H

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Custom SQL Data Type Definition
///
///
////////////////////////////////////////////////////////////////////////////////////////////////////

#define SQL_SF_TIMESTAMP_LTZ 2000
#define SQL_SF_TIMESTAMP_TZ  2001
#define SQL_SF_TIMESTAMP_NTZ 2002
#define SQL_SF_ARRAY         2003
#define SQL_SF_OBJECT        2004
#define SQL_SF_VARIANT       2005


#define SQL_SF_TIMESTAMP_TZ_COLUMN_SIZE    35
#define SQL_SF_TIMESTAMP_DEFAULT_SCALE     9
#define SQL_SF_TIMESTAMP_COLUMN_SIZE       29
#define SQL_SF_TEXT_COLUMN_LEN             16777216


// Custom attribute base
// https://docs.microsoft.com/en-us/sql/odbc/reference/develop-app/driver-specific-data-types-descriptor-information-diagnostic?view=sql-server-2017
#ifndef SQL_DRIVER_CONN_ATTR_BASE
  #define SQL_DRIVER_CONN_ATTR_BASE   0x00004000
#endif

#define SQL_SF_CONN_ATTR_BASE (SQL_DRIVER_CONN_ATTR_BASE + 0x53)
// Custom Connnection attribute for private key
// The value should be a PCKS8 key in standard Base64 encoded format
#define SQL_SF_CONN_ATTR_PRIV_KEY (SQL_SF_CONN_ATTR_BASE + 1)
#define SQL_SF_CONN_ATTR_APPLICATION (SQL_SF_CONN_ATTR_BASE + 2)

#define SQL_SF_STMT_ATTR_BASE (SQL_DRIVER_STMT_ATTR_BASE + 0x106)
#define SQL_SF_STMT_ATTR_LAST_QUERY_ID (SQL_SF_STMT_ATTR_BASE + 1)

#endif //PROJECT_SF_ODBC_H
